library(memisc)
library(mestats)
source("panel-envelope.R")
load("mclogit-classd-churchat.RData")

newdata.econdim.time <- expand.grid(
  econdim = c(-1,1),
  authlib = 0,
  tradmod = 0,
  classd = factor(1:4,labels=mclogit.classd.churchat$xlevels$classd),
  churchat = factor(1:3,levels=1:3,labels=mclogit.classd.churchat$xlevels$churchat),
  Year = c(seq(from=1975,to=1994,length=21),1994)
  )

newdata.authlib.time <- expand.grid(
  authlib = c(-1,1),
  econdim = 0,
  tradmod = 0,
  classd = factor(1:4,labels=mclogit.classd.churchat$xlevels$classd),
  churchat = factor(1:3,levels=1:3,labels=mclogit.classd.churchat$xlevels$churchat),
  Year = c(seq(from=1975,to=1994,length=21),1994)
  )

newdata.tradmod.time <- expand.grid(
  tradmod = c(-1,1),
  authlib = 0,
  econdim = 0,
  classd = factor(1:4,labels=mclogit.classd.churchat$xlevels$classd),
  churchat = factor(1:3,levels=1:3,labels=mclogit.classd.churchat$xlevels$churchat),
  Year = c(seq(from=1975,to=1994,length=21),1994)
  )

newdata.compare.time <- collect(
  "Party A econ. left (-1),\nparty B econ. right (1)"=newdata.econdim.time,
  "Party A libertarian (-1),\nparty B authoritarian (1)"=newdata.authlib.time,
  "Party A modernist (-1),\nparty B traditionalist (1)"=newdata.tradmod.time,
  sourcename="Dimension"
  )

newdata.compare.time <- within(newdata.compare.time,{
  choice.set <- rep(seq_len(nrow(newdata.compare.time) %/% 2),each=2)
  id <- rep(1:2, nrow(newdata.compare.time) %/% 2)
  party <- rep(1:2, nrow(newdata.compare.time) %/% 2) # These variables
  eb <- 40                                            # have no ocnsequences
  Time <- (Year - min(Year))/(max(Year) - min(Year)) - .5
  })


newdata.compare.time <- within(newdata.compare.time,{
  link <- predict(mclogit.classd.churchat,newdata=newdata.compare.time,conditional=FALSE)
  pred.resp <- predict(mclogit.classd.churchat,
                       newdata=newdata.compare.time,
                       type="response",
                       se=TRUE,
                       conditional=FALSE)
  prob <- pred.resp$pred
  se.prob <- pred.resp$se.pred
  # With the mclogit package use these lines:
  #prob <- pred.resp$fit
  #se.prob <- pred.resp$se.fit
  prob.lower <- qnorm(p=0.025,mean=prob,sd=se.prob)
  prob.upper <- qnorm(p=1-0.025,mean=prob,sd=se.prob)
  rm(pred.resp)
  churchat <- factor(churchat,labels=c("Non-churchgoer","Occasional churchgoer","Weekly churchgoer"))
})




strip.lop <- vector(mode="list",length=3)
strip.lop[[1]] <- 2.5
strip.lop[[2]] <- "lines"
strip.lop[3] <- list(NULL)
names(strip.lop) <- c("x","unit","data")

xyplot.classd.compare.time <- xyplot(
  withLimits(prob,prob.lower,prob.upper)~Year|Dimension,
    groups=classd,
    data=newdata.compare.time,
    type="l",
    subset=(id==1 & as.numeric(churchat)==2),
    ylim=c(0.15,0.85),
    ylab="Probability to vote for party A",
    layout=c(3,1),
    aspect=1,
    auto.key=list(points=FALSE,lines=TRUE,columns=2),
    scales=list(alternating=1,tck=c(1,0)),
    panel=function(x,y,...){
            panel.grid(h=-1,v=0,col="gray80")
            panel.envelope(x,y,...)
    },
    lattice.options=list(layout.heights=list(strip=strip.lop)),
    par.settings=list(
      superpose.symbol=list(col="black",pch=15:18,cex=c(.8,.9,.8,1)),
      superpose.line=list(col="black",lty=c(1,2,5,4),lwd=1.5),
      strip.background=list(col="white")
      )
  )

print(xyplot.classd.compare.time)


xyplot.churchat.compare.time <- xyplot(
  withLimits(prob,prob.lower,prob.upper)~Year|Dimension,
    groups=churchat,
    data=newdata.compare.time,
    type="l",
    subset=(id==2 & as.numeric(classd)==2),
    ylim=c(0.15,0.85),
    ylab="Probability to vote for party B",
    layout=c(3,1),
    aspect=1,
    auto.key=list(points=FALSE,lines=TRUE,columns=2),
    scales=list(alternating=1,tck=c(1,0)),
    panel=function(x,y,...){
            panel.grid(h=-1,v=0,col="gray80")
            panel.envelope(x,y,...)
    },
    lattice.options=list(layout.heights=list(strip=strip.lop)),
    par.settings=list(
      superpose.symbol=list(col="black",pch=15:18,cex=c(.8,.9,.8,1)),
      superpose.line=list(col="black",lty=c(1,2,5,4),lwd=1.5),
      strip.background=list(col="white")
      )
  )

print(xyplot.churchat.compare.time)

trellis.device(postscript,file="Figure1.eps",
               width=8,height=4.5,horizontal=FALSE)
print(xyplot.classd.compare.time)
dev.off()

trellis.device(pdf,file="Figure1.pdf",
               width=8,height=4.5)
print(xyplot.classd.compare.time)
dev.off()

trellis.device(postscript,file="Figure2.eps",
               width=8,height=4.5,horizontal=FALSE)
print(xyplot.churchat.compare.time)
dev.off()

trellis.device(pdf,file="Figure2.pdf",
               width=8,height=4.5)
print(xyplot.churchat.compare.time)
dev.off()
